/******************************************************************************
 *
 *       Copyright Zebra Technologies, Inc. 2014 - 2015
 *
 *       The copyright notice above does not evidence any
 *       actual or intended publication of such source code.
 *       The code contains Zebra Technologies
 *       Confidential Proprietary Information.
 *
 *
 *  Description:  HomeVCConstraints.m
 *
 *  Notes:
 *
 ******************************************************************************/

#import "HomeVCConstraints.h"
#import "UIColor+DarkModeExtension.h"
#import "RFIDDemoApp-Swift.h"
#import "ImpingTagProtectViewController.h"
#import "ImpinjInventoryVC.h"

@interface zt_HomeVCConstraints ()

@property (nonatomic, strong) UIButton *m_btnRapidRead;
@property (nonatomic, strong) UIButton *m_btnInventory;
@property (nonatomic, strong) UIButton *m_btnSettings;
@property (nonatomic, strong) UIButton *m_btnLocateTag;
@property (nonatomic, strong) UIButton *m_btnFilter;
@property (nonatomic, strong) UIButton *m_btnAccess;
@property (nonatomic, strong) UIStackView *row1_View;
@property (nonatomic, strong) UIStackView *row2_View;
@property (nonatomic, strong) UIStackView *row3_View;

@property (nonatomic, strong) NSNumber *m_padding;
@property (nonatomic) BOOL filterWasOpened;
@end

@implementation zt_HomeVCConstraints

/* default cstr for storyboard */
- (id)initWithCoder:(NSCoder *)aDecoder
{
    self = [super initWithCoder:aDecoder];
    if (self != nil)
    {
       
    }
    return self;
}

- (void)dealloc
{
    [super dealloc];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
    self.navigationController.navigationBar.tintColor = UIColor.whiteColor;
//    if (_filterWasOpened) {
//        _filterWasOpened = NO;
//        
//        zt_SledConfiguration *localSled = [[zt_RfidAppEngine sharedAppEngine] temporarySledConfigurationCopy];
//        zt_SledConfiguration *sled = [[zt_RfidAppEngine sharedAppEngine] sledConfiguration];
//        
//        if (![[[zt_RfidAppEngine sharedAppEngine] activeReader] isActive])
//        {
//            //zt_AlertView *alert = [[zt_AlertView alloc] init];
//            //[alert showWarningText:self.view withString:ZT_WARNING_NO_READER];
//            return;
//        }
//        
//        
//        if ((localSled.applyFirstFilter &&
//             ![zt_SledConfiguration isPrefilterEqual:localSled.currentPrefilters[0] withPrefilter:sled.currentPrefilters[0]]) ||
//            (localSled.applySecondFilter &&
//             ![zt_SledConfiguration isPrefilterEqual:localSled.currentPrefilters[1] withPrefilter:sled.currentPrefilters[1]]) ||
//            (localSled.applyFirstFilter != sled.applyFirstFilter || localSled.applySecondFilter != sled.applySecondFilter)
//            )
//
//        {
//            BOOL valid = true;
//    
//            if (YES == localSled.applyFirstFilter)
//            {
//                valid = [localSled isPrefilterValid:localSled.currentPrefilters[0]];
//            }
//            if (YES == valid)
//            {
//                if (YES == localSled.applySecondFilter)
//                {
//                    valid = [localSled isPrefilterValid:localSled.currentPrefilters[1]];
//                }
//            }
//            
//            if (YES == valid)
//            {
//                [self applyNewSetting:@"Saving filter settings"];
//                return;
//            }
//            else
//            {
//                [self showInvalidParamsWarning];
//            }
//        }
//        else
//        {
//            return;
//        }
//    
//        // if we get here, that means some parameters are invalid
//        // restore values if need
//        [[zt_RfidAppEngine sharedAppEngine] restorePrefilters];
//        [self darkModeCheck:self.view.traitCollection];
//    }
    
}
                   
- (void)showWarning:(NSString *)message
{
    dispatch_async(dispatch_get_main_queue(), ^{
//        zt_AlertView *alertView = [[zt_AlertView alloc]init];
//        [alertView showSuccessFailureWithText:self.view isSuccess:NO aSuccessMessage:@"" aFailureMessage:message];
        [self showOnlyMessageWithDurationWithMessage:message time:2];
    });
}
           
                   
- (void)applyNewSetting:(NSString *)message
{
    zt_AlertView *alertView = [[zt_AlertView alloc]init];
    [alertView showAlertWithView:self.view withTarget:self withMethod:@selector(updateFilters) withObject:nil withString:message];
}

- (void)updateFilters
{
    NSString *response;
    SRFID_RESULT result = [[zt_RfidAppEngine sharedAppEngine] setPrefilters:&response];
    
    [self handleCommandResult:result withStatusMessage:response];
    
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

-(BOOL)isReaderIsConnected{
    
    if ([[[zt_RfidAppEngine sharedAppEngine] activeReader] isActive])
    {
        return  YES;
    }else
    {
        dispatch_async(dispatch_get_main_queue(), ^{
            [self showOnlyMessageWithDurationWithMessage:ZT_WARNING_NO_READER time:4];
        });
        return  NO;
        
    }
}

- (IBAction)btnRapidReadPressed:(id)sender
{
   // [self showTabInterfaceActiveView:ZT_VC_RFIDTAB_RAPID_READ_VC_IDX];
    //tagProtect
    
    if([self isReaderIsConnected]){
        
        ImpingTagProtectViewController *impinjTagProtectVC = nil;
        impinjTagProtectVC = (ImpingTagProtectViewController*)[[UIStoryboard storyboardWithName:IMPINJ_TAG_CONFIG_STORYBOARD_NAME bundle:[NSBundle mainBundle]] instantiateViewControllerWithIdentifier:IMPINJ_TAG_PROTECT_BOARD_ID];

        [self.navigationController pushViewController:impinjTagProtectVC animated:YES];
    }
  
}

- (IBAction)btnInventoryPressed:(id)sender
{
    if([self isReaderIsConnected]){
        [self showTabInterfaceActiveView:ZT_VC_RFIDTAB_INVENTORY_VC_IDX];
    }
}

- (IBAction)btnSettingsPressed:(id)sender
{
    zt_SettingsVC*settings_vc = (zt_SettingsVC*)[[UIStoryboard storyboardWithName:@"RFIDDemoApp" bundle:[NSBundle mainBundle]] instantiateViewControllerWithIdentifier:@"ID_SETTINGS_VC"];
    
    if (nil != settings_vc)
    {
        [[self navigationController] pushViewController:settings_vc animated:YES];
    }
}

- (IBAction)btnLocateTagPressed:(id)sender
{
    
    //enable Tag Focus
    if([self isReaderIsConnected]){
        
        SRFID_RESULT result = SRFID_RESULT_FAILURE;
        NSString *status = [[NSString alloc] init];
        
        result = [[zt_RfidAppEngine sharedAppEngine]enableTagFocus:YES
                                                    aStatusMessage:&status];
        
        if (result == SRFID_RESULT_SUCCESS)
        {
            SRFID_RESULT result1 = SRFID_RESULT_FAILURE;
            NSString *status1 = [[NSString alloc] init];
            
            result1 = [[zt_RfidAppEngine sharedAppEngine]getPrefilters :&status1];
            
            if (result1 == SRFID_RESULT_SUCCESS)
            {
                NSLog(@"SRFID_RESULT_SUCCESS");
                
                NSNumber *sessionIndex = @1;
                [[NSUserDefaults standardUserDefaults] setObject:sessionIndex forKey:@"SavedSessionIndex"];
                
                [[NSUserDefaults standardUserDefaults] setBool:YES forKey:@"TagFocusEnabled"];
                [[NSUserDefaults standardUserDefaults]synchronize];
            }else{
                NSLog(@"SRFID_RESULT_Fail");
                [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"TagFocusEnabled"];
                [[NSUserDefaults standardUserDefaults]synchronize];
            }
            
            
            [self showWarning:@"Impinj Enable Tag Focus Success!"];
        }else{
            
            [self showWarning:@"Impinj Enable Tag Focus Fail !"];
        }
        
        
    }
    
}

- (IBAction)btnFilterPressed:(id)sender
{
    //tag quiet
    if([self isReaderIsConnected]){
        [[NSUserDefaults standardUserDefaults] setBool:NO forKey:@"TagFocusEnabled"];
        [[NSUserDefaults standardUserDefaults]synchronize];
        ImpinjInventoryVC *impinjInventoryVC = nil;
        impinjInventoryVC = (ImpinjInventoryVC*)[[UIStoryboard storyboardWithName:IMPINJ_TAG_CONFIG_STORYBOARD_NAME bundle:[NSBundle mainBundle]] instantiateViewControllerWithIdentifier:@"IMPINJ_INVENTORY_BOARD_ID"];
        [self.navigationController pushViewController:impinjInventoryVC animated:YES];
    }
}

- (IBAction)btnAccessPressed:(id)sender
{
    
    //disable Tag Focus
    //tag quiet
    if([self isReaderIsConnected]){
        
        SRFID_RESULT result = SRFID_RESULT_FAILURE;
        NSString *status = [[NSString alloc] init];
        
        result = [[zt_RfidAppEngine sharedAppEngine]enableTagFocus:NO
                                                    aStatusMessage:&status];
        
        if (result == SRFID_RESULT_SUCCESS)
        {
            zt_SledConfiguration *local = [[zt_RfidAppEngine sharedAppEngine] sledConfiguration];
            [local setPrefilterEnabled:0];
            [self showWarning:@"Impinj Disable Tag Focus Success!"];
        }else{
            [self showWarning:@"Impinj Disable Tag Focus Failed!"];
        }
    }
}


- (void)showTabInterfaceActiveView:(int)identifier
{
    zt_RFIDTabVC *tab_vc = (zt_RFIDTabVC*)[[UIStoryboard storyboardWithName:@"RFIDDemoApp" bundle:[NSBundle mainBundle]] instantiateViewControllerWithIdentifier:@"ID_RFID_TAB_VC"];
    [tab_vc setActiveView:identifier];
    
    if (nil != tab_vc)
    {
        [[self navigationController] pushViewController:tab_vc animated:YES];
    }
}

#pragma mark - Dark mode handling

/// Check whether darkmode is changed
/// @param traitCollection The traits, such as the size class and scale factor.
-(void)darkModeCheck:(UITraitCollection *)traitCollection
{
    self.m_btnRapidRead.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.m_btnInventory.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.m_btnSettings.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.m_btnLocateTag.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.m_btnFilter.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.m_btnAccess.titleLabel.textColor = [UIColor getDarkModeLabelTextColor:traitCollection];
    self.view.backgroundColor = [UIColor getDarkModeViewBackgroundColor:traitCollection];
   
}

/// Notifies the container that its trait collection changed.
/// @param traitCollection The traits, such as the size class and scale factor,.
/// @param coordinator The transition coordinator object managing the size change.
- (void)willTransitionToTraitCollection:(UITraitCollection *)traitCollection withTransitionCoordinator:(id<UIViewControllerTransitionCoordinator>)coordinator {
    NSLog(@"Dark Mode change");
    [self darkModeCheck:traitCollection];
}

@end
